/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.element;

import com.terraforged.mod.client.gui.element.Element;
import com.terraforged.mod.client.gui.element.TFButton;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TFRandButton
extends TFButton {
    private final String name;
    private final String prefix;
    private final List<String> tooltip;
    private final CompoundNBT container;
    private int value;
    private final int min;
    private final int max;
    private Runnable callback = () -> {};

    public TFRandButton(String name, CompoundNBT value) {
        super(value.func_74779_i(name));
        this.name = name;
        this.container = value;
        this.value = value.func_74762_e(name);
        this.prefix = Element.getDisplayName(name, value) + ": ";
        this.tooltip = Element.getToolTip(name, value);
        this.min = TFRandButton.getLimit(value, name, "min", Integer.MIN_VALUE);
        this.max = TFRandButton.getLimit(value, name, "max", Integer.MAX_VALUE);
        this.func_238482_a_((ITextComponent)new StringTextComponent(this.prefix + this.value));
    }

    public TFRandButton callback(Runnable runnable) {
        this.callback = runnable;
        return this;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    public void func_230930_b_() {
        this.value = ThreadLocalRandom.current().nextInt(this.min, this.max);
        this.container.func_74768_a(this.name, this.value);
        this.func_238482_a_((ITextComponent)new StringTextComponent(this.prefix + this.value));
        this.callback.run();
    }

    private static int getLimit(CompoundNBT value, String name, String limitType, int defaultLimit) {
        CompoundNBT meta = value.func_74775_l('#' + name);
        if (meta.func_74764_b(limitType)) {
            return meta.func_74762_e(limitType);
        }
        return defaultLimit;
    }
}

